/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.entrypoint;

import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.BYGWorldTypeThatIsntAWorldtype;
import corgiaoc.byg.common.world.feature.blockplacer.BYGBlockPlacerTypes;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.BYGEntities;
import corgiaoc.byg.core.BYGItems;
import corgiaoc.byg.core.BYGSounds;
import corgiaoc.byg.core.BYGTileEntities;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGContainerTypes;
import corgiaoc.byg.core.world.BYGDecorators;
import corgiaoc.byg.core.world.BYGFeatures;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.data.providers.BYGBlockTagsProvider;
import corgiaoc.byg.entrypoint.EntryPoint;
import corgiaoc.byg.mixin.access.FillerBlockTypeAccess;
import java.nio.file.Path;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="byg")
@Mod.EventBusSubscriber(modid="byg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeEntryPoint
implements EntryPoint {
    public ForgeEntryPoint() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        BYG.entryPoint = this;
        BYG.CONFIG_PATH = this.configDirectory();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BYG.commonLoad();
        event.enqueueWork(BYG::threadSafeCommonLoad);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BYG.clientLoad();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(BYG::threadSafeLoadFinish);
    }

    @Override
    public Path configDirectory() {
        return FMLPaths.CONFIGDIR.get().resolve("byg");
    }

    @Override
    public IPacket<?> getEntitySpawnPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BYG.LOGGER.debug("BYG: Registering blocks...");
        BYGBlocks.blocksList.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
        BYGBlocks.flowerPotBlocks.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
        BYG.LOGGER.info("BYG: Blocks registered!");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BYG.LOGGER.debug("BYG: Registering items...");
        BYGItems.itemsList.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        BYG.LOGGER.info("BYG: Items registered!");
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        BYG.LOGGER.debug("BYG: Registering entities...");
        BYGEntities.entities.forEach(entityType -> event.getRegistry().register((IForgeRegistryEntry)entityType));
        BYG.LOGGER.info("BYG: Entities registered!");
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        BYG.LOGGER.debug("BYG: Registering block entities...");
        BYGTileEntities.BLOCK_ENTITIES.forEach(entityType -> event.getRegistry().register((IForgeRegistryEntry)entityType));
        BYG.LOGGER.info("BYG: Block Entities registered!");
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        BYG.LOGGER.debug("BYG: Registering sounds...");
        BYGSounds.SOUNDS.forEach(soundEvent -> event.getRegistry().register((IForgeRegistryEntry)soundEvent));
        BYG.LOGGER.info("BYG: Sounds registered!");
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        BYG.LOGGER.debug("BYG: Registering block entities...");
        BYGEntities.init();
        BYGContainerTypes.CONTAINER_TYPES.forEach(containerType -> event.getRegistry().register((IForgeRegistryEntry)containerType));
        BYG.LOGGER.info("BYG: Block Entities registered!");
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        BYG.LOGGER.debug("BYG: Registering biomes...");
        BYGBiomes.init();
        BYGBiomes.biomeList.sort(Comparator.comparingInt(BYGBiomes.PreserveBiomeOrder::getOrderPosition));
        BYGBiomes.biomeList.forEach(preserveBiomeOrder -> event.getRegistry().register((IForgeRegistryEntry)preserveBiomeOrder.getBiome()));
        BYGBiomes.CANYON_KEY = BYGBiomes.CANYON.getKey();
        BYG.LOGGER.info("BYG: Biomes registered!");
    }

    @SubscribeEvent
    public static void registerDecorators(RegistryEvent.Register<Placement<?>> event) {
        BYG.LOGGER.debug("BYG: Registering decorators...");
        BYGDecorators.init();
        BYGDecorators.decorators.forEach(decorator -> event.getRegistry().register((IForgeRegistryEntry)decorator));
        BYG.LOGGER.info("BYG: Decorators registered!");
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        BYG.LOGGER.debug("BYG: Registering structures...");
        BYGStructures.init();
        BYG.LOGGER.info("BYG: Structures registered!");
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        BYG.LOGGER.debug("BYG: Registering features...");
        FillerBlockTypeAccess.setNetherFillerType((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_242173_aI));
        BYGFeatures.init();
        BYGFeatures.features.forEach(feature -> event.getRegistry().register((IForgeRegistryEntry)feature));
        BYG.LOGGER.info("BYG: Features registered!");
    }

    @SubscribeEvent
    public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        BYG.LOGGER.debug("BYG: Registering surface builders...");
        BYGSurfaceBuilders.init();
        BYGSurfaceBuilders.surfaceBuilders.forEach(surfaceBuilder -> event.getRegistry().register((IForgeRegistryEntry)surfaceBuilder));
        BYG.LOGGER.info("BYG: Surface builders Registered!");
    }

    @SubscribeEvent
    public static void registerBlockPlacerType(RegistryEvent.Register<BlockPlacerType<?>> event) {
        BYG.LOGGER.debug("BYG: Registering block placer types...");
        BYGBlockPlacerTypes.init();
        BYGBlockPlacerTypes.types.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
        BYG.LOGGER.info("BYG: Registering block placer types!");
    }

    @SubscribeEvent
    public static void registerWorldtype(RegistryEvent.Register<ForgeWorldType> event) {
        event.getRegistry().register(new BYGWorldTypeThatIsntAWorldtype().setRegistryName(new ResourceLocation("byg", "world")));
    }

    @SubscribeEvent
    public static void data(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new BYGBlockTagsProvider(event.getGenerator(), event.getExistingFileHelper()));
    }
}

